
// Neurosis Engine - LP23.com
// Copyright  Luigi Pino. All rights reserved.

/***************************************************************************/

#ifndef _NEUROSIS_ENGINE_AUDIO_H_
#define _NEUROSIS_ENGINE_AUDIO_H_

/***************************************************************************/

#include "../neurosis/openal/vorbisfile.h"
#include <vector>

/***************************************************************************/

#pragma comment(lib, "code/neurosis/openal/ogg_static.lib")
#pragma comment(lib, "code/neurosis/openal/openal32.lib")
#pragma comment(lib, "code/neurosis/openal/vorbis_static.lib")
#pragma comment(lib, "code/neurosis/openal/vorbisfile_static.lib")

/***************************************************************************/

//------------------------------------------------
#define AUDIO_BUFFER							32768								// 32 KB buffer
#define AL_PLAYING								0x1012
#define AL_PAUSED									0x1013
#define AL_STOPPED								0x1014
//------------------------------------------------

/***************************************************************************/

//! Note: iChannel = [0..totalChannels-1]
class CNeurosisAudio {
	public:
		CNeurosisAudio(int totalChannels = 4);
		//! Constructor/Deconstructor
		~CNeurosisAudio();

		//! Clear memory
		void	Clear(int iChannel);
		//! Either AL_PLAYING, AL_PAUSED, or AL_STOPPED
		int		Get_State(int iChannel);
		//! Check if OpenAL initialized properly (i.e. total channels > 0)
		bool	Is_Initialized();
		//! Load *.ogg audio file
		bool	Load(int iChannel, char *filename, bool stream);
		//! Whether to loop audio (only streamed audio)
		void	Loop(int iChannel, bool loopAudio);
		//! Play
		void	Play(int iChannel);
		//! Pause
		void	Pause(int iChannel);
		//! Stop
		void	Stop(int iChannel);
		//! Set volume [0.0f..1.0f]
		void	Volume(int iChannel, float volumeAmount);
		//! Update all channels
		void	Update();

	private:
		class CAudioData {
			public:
				bool	Stream(unsigned int buffer);
				void	Update();

				OggVorbis_File		pOggFile;										// File pointer for streaming data
				std::vector<char>	pBufferData;								// Buffer for non-streaming data

				bool							mInUse;											// Whether data file was loaded
				bool							mLoop;											// Whether to loop audio
				bool							mStream;										// Whether to stream audio
				int								mFormat;										// AL_FORMAT_MONO16, AL_FORMAT_STEREO16;
				int								mSamplingRate;							// Frequency
//			int								mState;											// AL_PLAYING, AL_PAUSED, AL_STOPPED
				unsigned int			mBufferID[2];								// Buffer
				unsigned int			mSourceID;									// Audio index
		};

		CAudioData	*pAudio;
		int					mTotalChannels;												// If mTotalChannels = 0, then OpenAl is not initialized
};

/***************************************************************************/
#endif